*****************************************************************************
* PROGRAM: 30_towns_t5
* PROGRAMMER: Modified by Gina Li at MIT, Oct. 2015
* PURPOSE: Makes Table 5 of Angrist, Lavy (2001) and outputs table into .csv
*****************************************************************************
capture log close
clear all

cd "`directory'"

set more off


log using "Table5.log", replace


use merge3h_public_final, clear

matrix t5 = J(14,6,.)

replace male4= male5 if male4==.
replace male4= male6 if male4==.
replace male4 = 0 if male4==2

gen ole4 = (migyear4 > 1951 & migyear4 != . )

replace dadedr4 = . if dadedr4 == 99
replace momedr4 = . if momedr4 == 99
replace famsize4 = . if famsize4 <= 1

gen married4 = mstatus4 == 2
gen age4 = 1994 - dobyear4

preserve

gen dif = hebsc5 - hebsc4

keep if relig == 0
keep if dif != .

count

reg dif treated

matrix t5[1,1] = _b[_cons]
matrix t5[2,1] = _se[_cons]
matrix t5[4,1] = _b[treated]
matrix t5[5,1] = _se[treated]

reg dif treated, cluster(school_rename)

matrix t5[3,1] = _se[_cons]
matrix t5[6,1] = _se[treated]

count

matrix t5[7,1] = e(N)

restore

preserve

gen dif = hebsc6 - hebsc5

keep if relig == 0
keep if dif != .

count
 
reg dif treated

matrix t5[1,2] = _b[_cons]
matrix t5[2,2] = _se[_cons]
matrix t5[4,2] = _b[treated]
matrix t5[5,2] = _se[treated]
reg dif treated, cluster(school_rename)

matrix t5[3,2] = _se[_cons]
matrix t5[6,2] = _se[treated]

count


matrix t5[7,2] = e(N)

restore

preserve

gen dif = hebsc6 - hebsc4

keep if relig == 0

keep if dif != .

count

reg dif treated

matrix t5[1,3] = _b[_cons]
matrix t5[2,3] = _se[_cons]
matrix t5[4,3] = _b[treated]
matrix t5[5,3] = _se[treated]

reg dif treated, cluster(school_rename)

matrix t5[3,3] = _se[_cons]
matrix t5[6,3] = _se[treated]
count

matrix t5[7,3] = r(N)
restore

preserve

gen dif = hebsc5 - hebsc4

keep if relig == 1

keep if dif != .

count

reg dif treated

matrix t5[8,1] = _b[_cons]
matrix t5[9,1] = _se[_cons]
matrix t5[11,1] = _b[treated]
matrix t5[12,1] = _se[treated]

reg dif treated, cluster(school_rename)

matrix t5[10,1] = _se[_cons]
matrix t5[13,1] = _se[treated]

count
 

matrix t5[14,1] = e(N)

restore




use merge3_public_final, clear

replace male4= male5 if male4==.
replace male4= male6 if male4==.
replace male4 = 0 if male4==2

gen ole4 = (migyear4 > 1951 & migyear4 != . )

replace dadedr4 = . if dadedr4 == 99
replace momedr4 = . if momedr4 == 99
replace famsize4 = . if famsize4 <= 1

gen married4 = mstatus4 == 2
gen age4 = 1994 - dobyear4

preserve

gen dif = mathsc5 - mathsc4

keep if relig == 0
keep if dif != .

count

reg dif treated

matrix t5[1,4] = _b[_cons]
matrix t5[2,4] = _se[_cons]
matrix t5[4,4] = _b[treated]
matrix t5[5,4] = _se[treated]

reg dif treated, cluster(school_rename)

matrix t5[3,4] = _se[_cons]
matrix t5[6,4] = _se[treated]

count
 
matrix t5[7,4] = e(N)

restore
 
preserve

gen dif = mathsc6 - mathsc5

keep if relig == 0
keep if dif != .
drop if mathsc4 == .

count

reg dif treated

matrix t5[1,5] = _b[_cons]
matrix t5[2,5] = _se[_cons]
matrix t5[4,5] = _b[treated]
matrix t5[5,5] = _se[treated]

reg dif treated, cluster(school_rename)

matrix t5[3,5] = _se[_cons]
matrix t5[6,5] = _se[treated]

count
  
matrix t5[7,5] = e(N)

restore

preserve

gen dif = mathsc6 - mathsc4

keep if relig == 0
keep if dif != .

count

reg dif treated

matrix t5[1,6] = _b[_cons]
matrix t5[2,6] = _se[_cons]
matrix t5[4,6] = _b[treated]
matrix t5[5,6] = _se[treated]

reg dif treated, cluster(school_rename)

matrix t5[3,6] = _se[_cons]
matrix t5[6,6] = _se[treated]

count

matrix t5[7,6] = r(N)

restore

preserve

gen dif = mathsc5 - mathsc4

keep if relig == 1

keep if dif != .

count

reg dif treated

matrix t5[8,4] = _b[_cons]
matrix t5[9,4] = _se[_cons]
matrix t5[11,4] = _b[treated]
matrix t5[12,4] = _se[treated]

reg dif treated, cluster(school_rename)

matrix t5[10,4] = _se[_cons]
matrix t5[13,4] = _se[treated]

count

matrix t5[14,4] = e(N)

restore

preserve

gen dif = mathsc6 - mathsc5

keep if relig == 1
keep if dif != .

drop if mathsc4 == .

count

reg dif treated

matrix t5[8,5] = _b[_cons]
matrix t5[9,5] = _se[_cons]
matrix t5[11,5] = _b[treated]
matrix t5[12,5] = _se[treated]

reg dif treated, cluster(school_rename)

matrix t5[10,5] = _se[_cons]
matrix t5[13,5] = _se[treated]

count

matrix t5[14,5] = r(N)

restore

preserve

gen dif = mathsc6 - mathsc4

keep if relig == 1
keep if dif != .


count

reg dif treated

matrix t5[8,6] = _b[_cons]
matrix t5[9,6] = _se[_cons]
matrix t5[11,6] = _b[treated]
matrix t5[12,6] = _se[treated]
reg dif treated, cluster(school_rename)

matrix t5[10,6] = _se[_cons]
matrix t5[13,6] = _se[treated]

count


matrix t5[14,6] = r(N)

restore

clear

svmat t5

outsheet using "table5_output.csv", comma replace

log close
